/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.soap;

import filenet.pe.soap.IPESOAPCommand;
import filenet.pe.soap.SOAPCommand;
import filenet.pe.soap.SOAPUtility;
import filenet.vw.api.VWApplicationSpace;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWCreateLiveWOResult;
import filenet.vw.api.VWDBExecuteConnection;
import filenet.vw.api.VWException;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWParticipantList;
import filenet.vw.api.VWProcess;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWQueueStats;
import filenet.vw.api.VWReturnStackElement;
import filenet.vw.api.VWRole;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWRosterStats;
import filenet.vw.api.VWSecurityDomain;
import filenet.vw.api.VWStepProcessorInfo;
import filenet.vw.api.VWTransferResult;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.CEObjectInfo;
import filenet.vw.base.VWParticipantCache;
import filenet.vw.base.VWXLIFFHandler;
import filenet.vw.base.logging.Logger;
import filenet.vw.base.logging.VWTimerLog;
import filenet.vw.server.IPECommands;
import filenet.vw.server.InternalVWWorkBasket;
import filenet.vw.server.VWConfigInfo;
import filenet.vw.server.VWConfigResult;
import filenet.vw.server.VWEnvironmentData;
import filenet.vw.server.VWEnvironmentDataQueryResults;
import filenet.vw.server.VWField;
import filenet.vw.server.VWInjectInfo;
import filenet.vw.server.VWLogonCredentials;
import filenet.vw.server.VWLogonResult;
import filenet.vw.server.VWQueryResults;
import filenet.vw.server.VWRMIRouterURL;
import filenet.vw.server.VWSecurityQueryResults;
import filenet.vw.server.VWSystemConfigInfo;
import filenet.vw.server.VWSystemWideInfo;
import filenet.vw.server.VWWorkObjectID;
import filenet.vw.server.VWWorkRecord;
import filenet.vw.soap.VWSOAPRouterURL;
import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class SOAPClientSession
implements IPECommands,
Serializable {
    private static final long serialVersionUID = 464L;
    private static Logger logger = Logger.getLogger("filenet.pe.soap");
    private String m_className = "SOAPClientSession";
    private String m_token = null;
    private String m_cpName = null;
    private VWSOAPRouterURL m_vwSoapRouterURL = null;
    protected transient IPESOAPCommand soapCmd = null;
    private Locale clientLocale = null;
    private transient VWXLIFFHandler myXliff = null;
    private Hashtable userInfoCache = new Hashtable(1);
    private long storeTime = System.currentTimeMillis();
    private String m_userName = null;
    private String m_serverName = null;
    private long m_securityId = -1L;
    private transient VWParticipantCache TheParticipantCache = new VWParticipantCache();
    private int m_isolatedRegion = -1;

    public static String _get_FILE_DATE() {
        return "$Date:   11 Sep 2008 13:28:02  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.33  $";
    }

    public SOAPClientSession() {
    }

    private String extractRealConnectionPointName(String s) {
        try {
            VWRMIRouterURL r = new VWRMIRouterURL(s);
            return r.getRouter();
        }
        catch (Exception e) {
            return s;
        }
    }

    public SOAPClientSession(String token, VWSOAPRouterURL vwSoapRouterURL) throws VWException {
        if (token == null) {
            token = "";
        }
        this.m_token = token;
        this.m_vwSoapRouterURL = vwSoapRouterURL;
        this.m_cpName = this.extractRealConnectionPointName(this.m_vwSoapRouterURL.getRouterName());
    }

    private void getSOAPCommand() {
        if (this.soapCmd == null) {
            this.soapCmd = new SOAPCommand(this.m_vwSoapRouterURL, this.m_token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object command(String rpc, Object[] params) throws VWException {
        String m_method = "command RPC=" + rpc;
        VWTimerLog timer = new VWTimerLog(rpc);
        try {
            Object res;
            if (logger.isFinest() && params != null && params.length > 0) {
                logger.finest(this.m_className, m_method, Logger.asString(params));
            }
            this.getSOAPCommand();
            Object object = res = SOAPUtility.BytesToObject(rpc, this.soapCmd.sendCommand(rpc, SOAPUtility.ObjectToBytes(rpc, params)));
            Object var8_7 = null;
            timer.stop();
            return object;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            timer.stop();
            throw throwable;
        }
    }

    public VWLogonResult logon(VWLogonCredentials credentials) throws VWException {
        throw new VWException("orb.session.notImplementedYet", "NOT IMPLEMENTED YET");
    }

    public void logoff() throws VWException {
    }

    public Hashtable getUserNames() throws VWException {
        Hashtable results = (Hashtable)this.command("getUserNames", new Object[0]);
        return results;
    }

    public VWSecurityQueryResults fetchUserList(int maxNumToReturn, int queryType, String startRecord, String searchPattern, String domain, int searchType, int sortType, long argFlag) throws VWException {
        VWSecurityQueryResults results = (VWSecurityQueryResults)this.command("fetchUserList", new Object[]{maxNumToReturn, queryType, startRecord, searchPattern, domain, searchType, sortType, new Long(argFlag)});
        return results;
    }

    public VWConfigResult getConfigInfo(boolean refresh) throws VWException {
        VWConfigResult result = (VWConfigResult)this.command("getConfigInfo", new Object[]{refresh});
        return result;
    }

    public Boolean recoverUser(String userName, String[] queueNames) throws VWException {
        Boolean result = (Boolean)this.command("recoverUser", new Object[]{userName, queueNames});
        return result;
    }

    public String[] getQueueOperations(String queueName) throws VWException {
        String[] results = (String[])this.command("getQueueOperations", new Object[]{queueName});
        return results;
    }

    public String[] getQueueNames(boolean includeSystemQueues, boolean ignoreSecurity) throws VWException {
        String[] results = (String[])this.command("getQueueNames", new Object[]{includeSystemQueues, ignoreSecurity});
        return results;
    }

    public String[] getRosterNames(boolean ignoreSecurity) throws VWException {
        String[] results = (String[])this.command("getRosterNames", new Object[]{ignoreSecurity});
        return results;
    }

    public String[] getWorkClassNames(boolean ignoreSecurity, String baseWorkClassName) throws VWException {
        String[] results = (String[])this.command("getWorkClassNames", new Object[]{ignoreSecurity, baseWorkClassName});
        return results;
    }

    public VWConfigInfo[] getWorkClassIdConfig() throws VWException {
        VWConfigInfo[] results = (VWConfigInfo[])this.command("getWorkClassIdConfig", new Object[0]);
        return results;
    }

    public VWAttributeInfo getAttributes(int nFlag) throws VWException {
        VWAttributeInfo results = (VWAttributeInfo)this.command("getAttributes", new Object[]{nFlag});
        return results;
    }

    public VWProcess getProcess(int workSpaceId, int workClassId, String workflowNumber) throws VWException {
        VWProcess results = (VWProcess)this.command("getProcess", new Object[]{workSpaceId, workClassId, workflowNumber});
        return results;
    }

    public String[] getLogNames() throws VWException {
        String[] results = (String[])this.command("getLogNames", new Object[0]);
        return results;
    }

    public String getCurrentVersion() throws VWException {
        String result = (String)this.command("getCurrentVersion", new Object[0]);
        return result;
    }

    public VWField[] getNewWorkObjectFields(String rosterName) throws VWException {
        VWField[] results = (VWField[])this.command("getNewWorkObjectFields", new Object[]{rosterName});
        return results;
    }

    public VWQueryResults fetch(int viewId, int queryType, int resultType, int maxNumToReturn, String indexName, Object[] minValues, Object[] maxValues, int queryFlags, String preFilterSQL, Object[] substitutionVarNames, VWWorkRecord startRecord, double rpUniqueId, boolean userBoundQuery, String logName, int workBasketId, String sortColumn, String[] filterNames) throws VWException {
        VWQueryResults results = (VWQueryResults)this.command("fetch", new Object[]{viewId, queryType, resultType, maxNumToReturn, indexName, minValues, maxValues, queryFlags, preFilterSQL, substitutionVarNames, startRecord, rpUniqueId, userBoundQuery, logName, workBasketId, sortColumn, filterNames});
        return results;
    }

    public Integer fetchCount(int viewId, int queryType, int resultType, String indexName, Object[] minValues, Object[] maxValues, int queryFlags, String preFilterSQL, Object[] substitutionVarNames, boolean userBoundQuery, String logName, int workBasketId, String sortColumn, String[] filterNames) throws VWException {
        Integer results = (Integer)this.command("fetchCount", new Object[]{viewId, queryType, resultType, indexName, minValues, maxValues, queryFlags, preFilterSQL, substitutionVarNames, userBoundQuery, logName, workBasketId, sortColumn, filterNames});
        return results;
    }

    public Integer getQueueDepth(int viewId, boolean userBoundQuery) throws VWException {
        Integer result = (Integer)this.command("getQueueDepth", new Object[]{viewId, userBoundQuery});
        return result;
    }

    public Integer getRosterCount(int viewId) throws VWException {
        Integer result = (Integer)this.command("getRosterCount", new Object[]{viewId});
        return result;
    }

    public Boolean getLoggingState(int viewId, int loggingOption) throws VWException {
        Boolean result = (Boolean)this.command("getLoggingState", new Object[]{viewId, loggingOption});
        return result;
    }

    public void logMessage(int viewId, int loggingOption, String message) throws VWException {
        this.command("logMessage", new Object[]{viewId, loggingOption, message});
    }

    public Object[] getLockStatus(int viewId, int queryType, VWWorkObjectID[] wobjHandles, boolean throwException, boolean userBoundQuery) throws VWException {
        Object[] results = (Object[])this.command("getLockStatus", new Object[]{viewId, queryType, wobjHandles, throwException, userBoundQuery});
        return results;
    }

    public Object[] unlockSave(int viewId, int queryType, VWWorkObjectID[] workObjectIds, int saveType, VWField[][] fieldValues, boolean bindAll, String userToBind, String exception, String exceptionDescription, boolean isExceptionMap, boolean unlockAll, boolean dispatchAll, boolean throwException, boolean userBoundQuery) throws VWException {
        Object[] results = (Object[])this.command("unlockSave", new Object[]{viewId, queryType, workObjectIds, saveType, fieldValues, bindAll, userToBind, exception, exceptionDescription, isExceptionMap, unlockAll, dispatchAll, throwException, userBoundQuery});
        return results;
    }

    public Boolean inject(String rosterName, VWField[][] fieldValues, String[] rosterNames, String sessionName, String transactionName) throws VWException {
        Boolean result = (Boolean)this.command("inject", new Object[]{rosterName, fieldValues, rosterNames, sessionName, transactionName});
        return result;
    }

    public VWInjectInfo getInjectSessionInfo(String rosterName, String sessionName, boolean nextName) throws VWException {
        VWInjectInfo result = (VWInjectInfo)this.command("getInjectSessionInfo", new Object[]{rosterName, sessionName, nextName});
        return result;
    }

    public Boolean deleteInjectSession(String rosterName, String sessionName) throws VWException {
        Boolean result = (Boolean)this.command("deleteInjectSession", new Object[]{rosterName, sessionName});
        return result;
    }

    public Object[] getWorkElementFields(int viewId, int queryType, VWWorkObjectID[] workObjectIds, int resultType, boolean lock, boolean overrideLock, boolean userBoundQuery, int queryFlags, int thecommand) throws VWException {
        Object[] results = null;
        if (queryType != 2 && queryType != 1) {
            throw new VWException("vw.server.VWCommandSessiongetWorkElementFieldsBadQType", "Bad Query Type{0}", Integer.valueOf(queryType).toString());
        }
        results = (Object[])this.command("getWorkElementFields", new Object[]{viewId, queryType, workObjectIds, resultType, lock, overrideLock, userBoundQuery, queryFlags, thecommand});
        return results;
    }

    public Hashtable getIndexFields(String queueName) throws VWException {
        Hashtable results = (Hashtable)this.command("getIndexFields", new Object[]{queueName});
        return results;
    }

    public String[] getExposedFields(String queueName) throws VWException {
        String[] results = (String[])this.command("getExposedFields", new Object[]{queueName});
        return results;
    }

    public Object[] terminateWorkObject(int viewId, int queryType, VWWorkObjectID[] wobjHandles, boolean throwException, boolean userBoundQuery) throws VWException {
        Object[] results = (Object[])this.command("terminateWorkObject", new Object[]{viewId, queryType, wobjHandles, throwException, userBoundQuery});
        return results;
    }

    public Object[] deleteWorkObject(int viewId, int queryType, VWWorkObjectID[] wobjHandles, boolean overrideLock, boolean force, boolean throwException, boolean userBoundQuery) throws VWException {
        Object[] results = (Object[])this.command("deleteWorkObject", new Object[]{viewId, queryType, wobjHandles, overrideLock, force, throwException, userBoundQuery});
        return results;
    }

    public void initializeAllRegions() throws VWException {
        this.command("initializeAllRegions", new Object[0]);
    }

    public void initializeRegion(boolean emptyIt, int webApp) throws VWException {
        this.command("initializeRegion", new Object[]{emptyIt, webApp});
    }

    public void removeDatabase() throws VWException {
        this.command("removeDatabase", new Object[0]);
    }

    public VWSystemWideInfo getSystemWideConfig() throws VWException {
        VWSystemWideInfo results = (VWSystemWideInfo)this.command("getSystemWideConfig", new Object[0]);
        return results;
    }

    public void setSystemWideConfig(VWSystemWideInfo sysInfo) throws VWException {
        this.command("setSystemWideConfig", new Object[]{sysInfo});
    }

    public Hashtable fetchServerConfiguration(String[] keyList) throws VWException {
        Hashtable results = (Hashtable)this.command("fetchServerConfiguration", new Object[]{keyList});
        return results;
    }

    private VWEnvironmentData[] getUserInfoFromCache(String[] theUserNameList) {
        if (theUserNameList == null || theUserNameList.length > 1) {
            return null;
        }
        if (System.currentTimeMillis() - this.storeTime <= 5000L) {
            return (VWEnvironmentData[])this.userInfoCache.get(theUserNameList[0]);
        }
        this.userInfoCache.remove(theUserNameList[0]);
        return null;
    }

    public VWEnvironmentData[] fetchUserInfo(String[] theUserNameList) throws VWException {
        VWEnvironmentData[] theResults = this.getUserInfoFromCache(theUserNameList);
        if (theResults == null) {
            theResults = (VWEnvironmentData[])this.command("fetchUserInfo", new Object[]{theUserNameList});
            if (theUserNameList != null && theUserNameList.length == 1) {
                this.userInfoCache.put(theUserNameList[0], theResults);
                this.storeTime = System.currentTimeMillis();
            }
        }
        return theResults;
    }

    public void saveUserInfo(VWEnvironmentData theUserInfo) throws VWException {
        this.command("saveUserInfo", new Object[]{theUserInfo});
    }

    public void deleteUserInfo(String theUserName) throws VWException {
        this.command("deleteUserInfo", new Object[]{theUserName});
    }

    public VWSystemConfigInfo getSystemConfigInfo(int productId) throws VWException {
        VWSystemConfigInfo theResults = (VWSystemConfigInfo)this.command("getSystemConfigInfo", new Object[]{productId});
        return theResults;
    }

    public VWTransferResult transfer(VWSystemConfigInfo systemConfigInfo, VWWorkflowDefinition wflDefinition, String theWFDocKey, boolean theLinked, boolean theMakeNewWorkSpace, int productId) throws VWException {
        VWTransferResult results = (VWTransferResult)this.command("transfer", new Object[]{systemConfigInfo, wflDefinition, theWFDocKey, theLinked, theMakeNewWorkSpace, productId});
        return results;
    }

    public VWTransferResult transferWorkflowCollection(String wfCollectionStr, String theWFDocKey, boolean theLinked, boolean theMakeNewWorkSpace) throws VWException {
        VWTransferResult results = (VWTransferResult)this.command("transferWorkflowCollection", new Object[]{wfCollectionStr, theWFDocKey, theLinked, theMakeNewWorkSpace});
        return results;
    }

    public VWRosterDefinition getRosterDefinition(String rosterName) throws VWException {
        VWRosterDefinition theResults = (VWRosterDefinition)this.command("getRosterDefinition", new Object[]{rosterName});
        return theResults;
    }

    public VWQueueDefinition getQueueDefinition(String queueName) throws VWException {
        VWQueueDefinition theResults = (VWQueueDefinition)this.command("getQueueDefinition", new Object[]{queueName});
        return theResults;
    }

    public VWLogDefinition getLogDefinition(String logName) throws VWException {
        VWLogDefinition theResults = (VWLogDefinition)this.command("getLogDefinition", new Object[]{logName});
        return theResults;
    }

    public void doReject(int viewId, int queryType, VWWorkObjectID workObjectId, int saveType) throws VWException {
        this.command("doReject", new Object[]{viewId, queryType, workObjectId, saveType});
    }

    public void doReassign(int viewId, int queryType, VWWorkObjectID workObjectId, int saveType, String domainName, String participantName, boolean delegateFlag, String queueName, VWField[] fieldValues, String exception, String exceptionDescription, boolean isExceptionMap, boolean throwException, boolean userBoundQuery, long argFlag) throws VWException {
        this.command("doReassign", new Object[]{viewId, queryType, workObjectId, saveType, domainName, participantName, delegateFlag, queueName, fieldValues, exception, exceptionDescription, isExceptionMap, throwException, userBoundQuery, new Long(argFlag)});
    }

    public void doReturn(int viewId, int queryType, VWWorkObjectID workObjectId, int saveType, VWField[] fieldValues, String exception, String exceptionDescription, boolean isExceptionMap, boolean throwException, boolean userBoundQuery) throws VWException {
        this.command("doReturn", new Object[]{viewId, queryType, workObjectId, saveType, fieldValues, exception, exceptionDescription, isExceptionMap, throwException, userBoundQuery});
    }

    public VWQueueStats getQueueStatistics(int viewId, Date startTime, Date endTime, int timeUnits) throws VWException {
        VWQueueStats result = (VWQueueStats)this.command("getQueueStatistics", new Object[]{viewId, startTime, endTime, timeUnits});
        return result;
    }

    public VWRosterStats getRosterStatistics(int viewId, Date startTime, Date endTime, int timeUnits) throws VWException {
        VWRosterStats result = (VWRosterStats)this.command("getRosterStatistics", new Object[]{viewId, startTime, endTime, timeUnits});
        return result;
    }

    public Boolean isMemberOfGroup(String groupName, String domainName, long rpcArgFlag) throws VWException {
        Boolean result = (Boolean)this.command("isMemberOfGroup", new Object[]{groupName, domainName, new Long(rpcArgFlag)});
        return result;
    }

    public Boolean[] fetchIsGroup(String[] names) throws VWException {
        Boolean[] results = (Boolean[])this.command("fetchIsGroup", new Object[]{names});
        return results;
    }

    public Boolean[] fetchAttachmentIsReferenced(VWAttachment[] theAttachments) throws VWException {
        Boolean[] results = (Boolean[])this.command("fetchAttachmentIsReferenced", new Object[]{theAttachments});
        return results;
    }

    public VWQueryResults fetchAttachmentIsReferencedBy(VWAttachment theAttachment, int theLimit, int workClassId, String wobNum) throws VWException {
        VWQueryResults results = (VWQueryResults)this.command("fetchAttachmentIsReferencedBy", new Object[]{theAttachment, theLimit, workClassId, wobNum});
        return results;
    }

    public VWField[] getNewStepElement(String workClassName, boolean returnWobNum) throws VWException {
        VWField[] results = (VWField[])this.command("getNewStepElement", new Object[]{workClassName, returnWobNum});
        return results;
    }

    public Object[] saveNewStepElement(VWField[] fieldValues, String workClassName, int workspaceId, VWField[] initialFieldValues) throws VWException {
        Object[] results = (Object[])this.command("saveNewStepElement", new Object[]{fieldValues, workClassName, workspaceId, initialFieldValues});
        return results;
    }

    public VWField[] getNewStepFromVWVersion(String vwversion) throws VWException {
        VWField[] results = (VWField[])this.command("getNewStepFromVWVersion", new Object[]{vwversion});
        return results;
    }

    public Boolean checkVWVersion(String vwversion) throws VWException {
        Boolean results = (Boolean)this.command("checkVWVersion", new Object[]{vwversion});
        return results;
    }

    public String getUserName() throws VWException {
        if (this.m_userName == null) {
            this.m_userName = (String)this.command("getUserName", new Object[0]);
        }
        return this.m_userName;
    }

    public String getToken() throws VWException {
        String token = (String)this.command("getToken", new Object[0]);
        return token;
    }

    public void removeLinkFlag(String theDocument) throws VWException {
        this.command("removeLinkFlag", new Object[]{theDocument});
    }

    public VWStepProcessorInfo[] getStepProcessorList(int processorType, int productId) throws VWException {
        VWStepProcessorInfo[] results = (VWStepProcessorInfo[])this.command("getStepProcessorList", new Object[]{processorType, productId});
        return results;
    }

    public VWStepProcessorInfo getLaunchStepProcessor(String workflowIdentifier, int productId) throws VWException {
        VWStepProcessorInfo results = (VWStepProcessorInfo)this.command("getLaunchStepProcessor", new Object[]{workflowIdentifier, productId});
        return results;
    }

    public VWStepProcessorInfo getStepProcessorByName(String processorName, int productId) throws VWException {
        VWStepProcessorInfo results = (VWStepProcessorInfo)this.command("getStepProcessorByName", new Object[]{processorName, productId});
        return results;
    }

    public VWStepProcessorInfo getStepProcessorById(int processorId, int productId) throws VWException {
        VWStepProcessorInfo results = (VWStepProcessorInfo)this.command("getStepProcessorById", new Object[]{processorId, productId});
        return results;
    }

    public VWCreateLiveWOResult[] createLiveWorkObject(String[] fieldNames, Object[] fieldValues, String workflowIdentifier, int numberToCreate) throws VWException {
        return (VWCreateLiveWOResult[])this.command("createLiveWorkObject", new Object[]{fieldNames, fieldValues, workflowIdentifier, numberToCreate});
    }

    public VWWorkflowSignature getWorkflowSignature(String workflowIdentifier) throws VWException {
        VWWorkflowSignature result = (VWWorkflowSignature)this.command("getWorkflowSignature", new Object[]{workflowIdentifier});
        return result;
    }

    public VWWorkflowSignature[] getMultipleWorkflowSignatures(int flags) throws VWException {
        VWWorkflowSignature[] result = (VWWorkflowSignature[])this.command("getMultipleWorkflowSignatures", new Object[]{flags});
        return result;
    }

    public String getFileFromServer(String fileName, int FileType) throws VWException {
        String result = (String)this.command("getFileFromServer", new Object[]{fileName, FileType});
        return result;
    }

    public Boolean getLimitApplicationFunctionalityFlag() throws VWException {
        Boolean result = (Boolean)this.command("getLimitApplicationFunctionalityFlag", new Object[0]);
        return result;
    }

    public String getWorkClassXML(int workSpaceId, String workflowIdentifier, boolean bAuthorForm, boolean bConvert) throws VWException {
        String results = (String)this.command("getWorkClassXML", new Object[]{workSpaceId, workflowIdentifier, bAuthorForm, bConvert});
        return results;
    }

    public String getServerName() throws VWException {
        String servername;
        int inx;
        if (this.m_serverName == null) {
            this.m_serverName = (String)this.command("getServerName", new Object[0]);
        }
        if ((inx = (servername = this.m_serverName).indexOf("||")) != -1) {
            this.m_serverName = servername.substring(0, inx);
        }
        return this.m_serverName;
    }

    public VWParticipant[] convertSecurityIdstoNames(Long[] ids) throws VWException {
        VWParticipant[] results = (VWParticipant[])this.command("convertSecurityIdstoNames", new Object[]{ids});
        return results;
    }

    public Long[] convertSecurityNamestoIds(String[] names, boolean assignId) throws VWException {
        Long[] results = (Long[])this.command("convertSecurityNamestoIds", new Object[]{names, assignId});
        return results;
    }

    public int getSecurityType() {
        return 1;
    }

    public boolean isSecurityCaseSensitive() {
        return false;
    }

    public long getSecurityId() throws VWException {
        if (this.m_securityId == -1L) {
            this.m_securityId = (Long)this.command("getSecurityId", new Object[0]);
        }
        return this.m_securityId;
    }

    public String getDefaultDomain() throws VWException {
        return "";
    }

    public VWReturnStackElement[] getReturnStackElements(int viewId, int queryType, VWWorkObjectID workObjectId, boolean userBoundQuery) throws VWException {
        if (queryType == 2 || queryType == 1) {
            return (VWReturnStackElement[])this.command("getReturnStackElements", new Object[]{viewId, queryType, workObjectId, userBoundQuery});
        }
        throw new VWException("vw.server.VWCommandSessiongetReturnStackElementsBadQType", "Bad Query Type{0}", Integer.valueOf(queryType).toString());
    }

    public VWEnvironmentDataQueryResults fetchUserEnvironmentRecords(int maxBufferSize, VWEnvironmentData startRecord, boolean throwException) throws VWException {
        VWEnvironmentDataQueryResults results = (VWEnvironmentDataQueryResults)this.command("fetchUserEnvironmentRecords", new Object[]{maxBufferSize, startRecord, throwException});
        return results;
    }

    public VWSecurityDomain[] fetchSecurityDomains() throws VWException {
        VWSecurityDomain[] results = null;
        results = (VWSecurityDomain[])this.command("fetchSecurityDomains", new Object[0]);
        return results;
    }

    public VWParticipant[] fetchParticipants(String domainName, String[] theUserNameList, long rpcArgFlag) throws VWException {
        int nItems;
        String m_method = "fetchParticipants";
        int n = nItems = theUserNameList == null ? 0 : theUserNameList.length;
        if (nItems == 0) {
            return null;
        }
        VWParticipant[] results = new VWParticipant[nItems];
        Vector listToFetch = new Vector(nItems);
        this.TheParticipantCache.checkNames(domainName, theUserNameList, results, listToFetch);
        if (listToFetch.size() > 0) {
            int nNewItems;
            String[] realList = listToFetch.toArray(new String[0]);
            VWParticipant[] realListParticipant = (VWParticipant[])this.command("fetchParticipants", new Object[]{domainName, realList, new Long(rpcArgFlag)});
            int n2 = nNewItems = realListParticipant == null ? 0 : realListParticipant.length;
            if (nNewItems != realList.length) {
                logger.severe(this.m_className, m_method, "Mistmatched participant List");
            } else {
                int j = 0;
                for (int i = 0; i < nItems; ++i) {
                    VWParticipant newParticipant;
                    if (results[i] != null) continue;
                    results[i] = newParticipant = realListParticipant[j];
                    this.TheParticipantCache.put(domainName, realList[j], newParticipant);
                    ++j;
                }
            }
        }
        return results;
    }

    public int getIsolatedRegion() {
        if (this.m_isolatedRegion == -1) {
            try {
                this.m_isolatedRegion = (Integer)this.command("getIsolatedRegion", new Object[0]);
            }
            catch (Exception e) {
                this.m_isolatedRegion = 1;
            }
        }
        return this.m_isolatedRegion;
    }

    public void ping() throws VWException {
    }

    public IPECommands getIPECommandsForDest(String dest) throws VWException {
        return this;
    }

    public String getServiceDestination() {
        return this.m_vwSoapRouterURL.toString();
    }

    public String getConnectionPointName() throws VWException {
        return this.m_cpName;
    }

    public String translate(String inStr) throws VWException {
        if (this.clientLocale != null) {
            String outStr;
            if (this.myXliff == null) {
                int myReg = this.getIsolatedRegion();
                this.myXliff = new VWXLIFFHandler(myReg);
            }
            if ((outStr = this.myXliff.getLocalizedString(this.clientLocale, inStr)) != null) {
                return outStr;
            }
        }
        return inStr;
    }

    public String translateToAuthored(String inStr) throws VWException {
        if (this.clientLocale != null) {
            String outStr;
            if (this.myXliff == null) {
                int myReg = this.getIsolatedRegion();
                this.myXliff = new VWXLIFFHandler(myReg);
            }
            if ((outStr = this.myXliff.getAuthoredString(this.clientLocale, inStr)) != null) {
                return outStr;
            }
        }
        return inStr;
    }

    public void setClientLocale(Locale myLocale) throws VWException {
        this.clientLocale = myLocale;
        if (this.clientLocale == null) {
            this.myXliff = null;
        } else if (this.myXliff == null) {
            int myReg = this.getIsolatedRegion();
            this.myXliff = new VWXLIFFHandler(myReg);
        }
    }

    public Locale getClientLocale() throws VWException {
        return this.clientLocale;
    }

    public String[] getAvailableLocales() throws VWException {
        String[] results = null;
        results = (String[])this.command("getAvailableLocales", new Object[0]);
        return results;
    }

    public String getServerLocale() throws VWException {
        String result = null;
        result = (String)this.command("getServerLocale", new Object[0]);
        return result;
    }

    public VWParticipantList fetchRoleParticipants(String roleName, String appSpaceName) throws VWException {
        VWParticipantList list = (VWParticipantList)this.command("fetchRoleParticipants", new Object[]{roleName, appSpaceName});
        return list;
    }

    public VWParticipantList fetchRoleParticipantsEx(String roleName, String appSpaceName, boolean isRuntimeCaller) throws VWException {
        VWParticipantList list = (VWParticipantList)this.command("fetchRoleParticipantsEx", new Object[]{roleName, appSpaceName, isRuntimeCaller});
        return list;
    }

    public VWRole fetchMyRole(String roleName, String appSpaceName) throws VWException {
        return (VWRole)this.command("fetchMyRole", new Object[]{roleName, appSpaceName});
    }

    public VWRole[] fetchMyRoles(String shortName, String appSpaceName) throws VWException {
        return (VWRole[])this.command("fetchMyRoles", new Object[]{shortName, appSpaceName});
    }

    public String[] fetchMemberOf(String userName) throws VWException {
        return (String[])this.command("fetchMemberOf", new Object[]{userName});
    }

    public InternalVWWorkBasket fetchMyWorkBasket(String roleName, String appSpaceName, int queueClassId, String workBasketName) throws VWException {
        return (InternalVWWorkBasket)this.command("fetchMyWorkBasket", new Object[]{roleName, appSpaceName, queueClassId, workBasketName});
    }

    public InternalVWWorkBasket[] fetchMyWorkBaskets(String roleName, String appSpaceName) throws VWException {
        return (InternalVWWorkBasket[])this.command("fetchMyWorkBaskets", new Object[]{roleName, appSpaceName});
    }

    public InternalVWWorkBasket[] fetchWorkBasketsForQueue(int queueClassId, String[] workBasketNames) throws VWException {
        return (InternalVWWorkBasket[])this.command("fetchWorkBasketsForQueue", new Object[]{queueClassId, workBasketNames});
    }

    public int fetchPrivileges() throws VWException {
        Integer flags = (Integer)this.command("fetchPrivileges", new Object[0]);
        if (flags != null) {
            return flags;
        }
        return 0;
    }

    public Boolean verifyDBConnection(VWDBExecuteConnection dbConnection) throws VWException {
        Boolean results = (Boolean)this.command("verifyDBConnection", new Object[]{dbConnection});
        return results;
    }

    public String[] fetchAppSpaceNames(boolean ignoreSecurity) throws VWException {
        return (String[])this.command("fetchAppSpaceNames", new Object[]{ignoreSecurity});
    }

    public String[] fetchRoleNames(int accessLevel, String orbInAppSpaceName) throws VWException {
        return (String[])this.command("fetchRoleNames", new Object[]{accessLevel, orbInAppSpaceName});
    }

    public VWRole[] fetchRoles(String orbInAppSpaceName, String[] orbInRoleNames) throws VWException {
        return (VWRole[])this.command("fetchRoles", new Object[]{orbInAppSpaceName, orbInRoleNames});
    }

    public VWParticipantList setRolePartipants(String orbInAppSpaceName, String orbInRoleName, String[] addParticipantNames, String[] removeParticipantNames) throws VWException {
        return (VWParticipantList)this.command("setRolePartipants", new Object[]{orbInAppSpaceName, orbInRoleName, addParticipantNames, removeParticipantNames});
    }

    public VWField[] createLaunchStepElement(String[] fieldNames, Object[] fieldValues, String workflowIdentifier, int i, boolean returnWobNum) throws VWException {
        return (VWField[])this.command("createLaunchStepElement", new Object[]{fieldNames, fieldValues, workflowIdentifier, i, returnWobNum});
    }

    public VWApplicationSpace[] fetchApplicationSpaces(String[] orbInAppSpaceNames, int orbInFilterFlag) throws VWException {
        return (VWApplicationSpace[])this.command("fetchApplicationSpaces", new Object[]{orbInAppSpaceNames, orbInFilterFlag});
    }

    public CEObjectInfo fetchCEObjectInfo(VWGuid objectStoreId, VWGuid classId, VWGuid objectId) throws VWException {
        return (CEObjectInfo)this.command("fetchCEObjectInfo", new Object[]{objectStoreId, classId, objectId});
    }

    public String fetchObjectStoreSymbolicName(VWGuid objectStoreId) throws VWException {
        return (String)this.command("fetchObjectStoreSymbolicName", new Object[]{objectStoreId});
    }

    public VWGuid fetchObjectStoreId(String objectStoreSymbolicName) throws VWException {
        return (VWGuid)this.command("fetchObjectStoreId", new Object[]{objectStoreSymbolicName});
    }

    public boolean verifyCreds() throws VWException {
        return true;
    }

    public VWGuid getObjectStoreId() throws VWException {
        return (VWGuid)this.command("getObjectStoreId", new Object[0]);
    }

    public CEObjectInfo fetchCEObjectInfoByName(VWGuid objectStoreId, String symbolicName) throws VWException {
        return (CEObjectInfo)this.command("fetchCEObjectInfoByName", new Object[]{objectStoreId, symbolicName});
    }
}

